#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h> /* mmap() is defined in this header */
#include <fcntl.h>
#include <time.h>
#include <assert.h>

#define MAXLEN 5000

#define min(a,b)	(((a)<(b))?(a):(b))
#define max(a,b)	(((a)>(b))?(a):(b))

char *sgets( char * str, int size, char ** stream ) {	
    int c,i;

    for ( i = 0; i < size-1; i++ ) {	
 	c = **stream; (*stream)++;
	if ( '\0' == c )
		return NULL;
	str[i]=c;
	if ( ('\n' == c) || ('\r' == c) ) {	
		/* str[i++]='\n'; */
		break;
	}
    }
    str[i] = '\0';

    return str;
}

int main (int argc, char *argv[]) {
    FILE *fp;
    int i;
    char train[64];
    char *src, *header, *s;
    struct stat statbuf;

    if (argc<3) {
	fprintf(stderr,"Usage: %s passive-predictions Q\n",argv[0]);
	exit(1);
    }

    int Q = atoi(argv[2]);
    int n, e;

    char line[MAXLEN], file_name[256];

    if (!(fp = fopen(argv[1],"r"))) {
        fprintf(stderr,"Failed to open %s for reading\n",argv[1]);
	exit(1);
    }

    int index, prediction, label;
    float confidence;

    n = e = 0;

    while (fgets(line,256,fp)) {
	sscanf(line,"%d %d %f %d\n",&index,&prediction,&confidence,&label);
	if (prediction != label) { e++; }
	n++;
    }

    // printf("%d test examples, %d mistakes (%2.3f)\n",n,e,e*100*pow(n,-1));
    printf("%d %d %d %2.3f\n",Q,n,e,e*100*pow(n,-1));
}
