#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h> /* mmap() is defined in this header */
#include <fcntl.h>
#include <time.h>
#include <assert.h>

#define MAXLEN 5000

FILE *pass_fp;

#define min(a,b)	(((a)<(b))?(a):(b))
#define max(a,b)	(((a)>(b))?(a):(b))

char *sgets( char * str, int size, char ** stream ) {	
    int c,i;

    for ( i = 0; i < size-1; i++ ) {	
 	c = **stream; (*stream)++;
	if ( '\0' == c )
		return NULL;
	str[i]=c;
	if ( ('\n' == c) || ('\r' == c) ) {	
		/* str[i++]='\n'; */
		break;
	}
    }
    str[i] = '\0';

    return str;
}

char *stoupper (char *s) {
     int i;
     char *S = (char *)malloc(strlen(s)+1);
     for(i=0;i<strlen(s);i++) {
	S[i]=toupper(s[i]);
     }
     S[i]='\0';
     return S;
}

int sisspace(char *s) {
    while((*s)!='\0') {
        if (!isspace(*s)) return 0;
        s++;
    }
    return 1;
}

void parse_header (char *src, char **header, int *attributes, int *k) {
    char *s = src;
    char line[MAXLEN], last_attribute[256], *tok, *c;

    sprintf(*header,""); *k=0; *attributes=0;
    while (sgets(line,256,&s)) {
        if (sisspace(line) || line[0]=='%') { continue; }
        sprintf(*header,"%s%s\n",*header,line);
        if (strstr(stoupper(line),"@ATTRIBUTE")) {
	    strcpy(last_attribute,line);
            (*attributes)++;
        }
        if (strcasecmp(stoupper(line),"@DATA"))
            continue;
        else
            break;
    }

    (*attributes)--;

    /* parse the classes: s */
    tok = strtok(last_attribute,"{");
    while((tok = strtok(NULL," \t,{}\n"))) {
	(*k)++;
    }
}

int main (int argc, char *argv[]) {
    int fp; 
    int i, j;
    char *src, *header;
    struct stat statbuf;
    char line[MAXLEN], prediction_line[256], command_line[256];

    if (argc<2) {
	// T - number of bootstrap classifiers
	// path to T binary prediction files + root
	// 	"yeast/trees.J48/yeast"
	// file stem: "yeast/yeast"
	fprintf(stderr,"Usage: %s file\n",argv[0]);
	exit(1);
    }

    sprintf(line,"cp %s.passive %s.temp",argv[1],argv[1]);
    system(line);

    sprintf(line,"%s.temp",argv[1]);
    if ((pass_fp = fopen(line,"a")) == NULL) {
            fprintf(stderr,"Can't open append file %s\n",line);
            exit(-1);
    }

    /* open the stream file */
    sprintf(line,"%s.stream",argv[1]);
    if ((fp = open(line,O_RDONLY)) < 0) {
        fprintf(stderr,"Can't open input file %s\n",line);
        exit(-1);
    }

    /* find size of the stream file */
    if (fstat (fp,&statbuf) < 0) {
        fprintf(stderr,"fstat error"); exit(1);
    }

    /* mmap the input file */
    if ((src = (char *) mmap (0, statbuf.st_size, PROT_READ, MAP_SHARED, fp, 0))
   	== (caddr_t) -1) {
   	fprintf(stderr,"mmap error for input"); exit(1);
    }

    header = (char *)malloc(sizeof(char)*statbuf.st_size);
    int attributes, k;

    parse_header(src,&header,&attributes,&k);

    int Q = 0;

    char name[64];
    strcpy(name,argv[1]);
    char *y = strchr(name,'/');
    *y = '\0';

    while (sgets(line,MAXLEN,&src)) { // read from the stream file
        if (sisspace(line) || line[0]=='%' || line[0]=='@') { continue; }

	Q++;
	fprintf(pass_fp,"%s\n",line);
	fflush(pass_fp);
	if (!((Q-1) % 10)) {
	    sprintf(command_line,"./script-passive %s %d",name,Q);
	    system(command_line);
	}
    }
    sprintf(command_line,"./script-passive %s %d",name,Q);
    system(command_line);
}
