let max_num_examples = 1000
let delta = 0.1
let log_delta = log delta

let _ = 
  let hoeffding = Array.create max_num_examples 0. 
  and sanov = Array.create max_num_examples 0. 
  and binomial = Array.create max_num_examples 0. in

  for i = 0 to max_num_examples-1 do
    hoeffding.(i) <- Search.monotone_decreasing (Agnostic.agnostic_upper 0. max_num_examples i) log_delta 0. 1.;
    sanov.(i) <- Search.monotone_decreasing (Relative_entropy.relative_entropy_upper 0. max_num_examples i) log_delta 0. 1.;
    binomial.(i) <- Search.monotone_decreasing (Binomial.binom_upper 0. max_num_examples i) log_delta 0. 1.;
  done;

  let hoeff_out = open_out "hoeffding" in
  let sanov_out = open_out "sanov" in
  let binomial_out = open_out "binomial" in
  for i = 0 to max_num_examples - 1 do
    let empirical = float i /. float max_num_examples in
    output_string hoeff_out (string_of_int i^" "^string_of_float (hoeffding.(i) -. empirical)^"\n");
    output_string sanov_out (string_of_int i^" "^string_of_float (sanov.(i) -. empirical)^"\n");
    output_string binomial_out (string_of_int i^" "^string_of_float (binomial.(i) -. empirical)^"\n");
  done;
  close_out hoeff_out;
  close_out sanov_out;
  close_out binomial_out;
  exit 0

  
