let loc = ref ""

let _ =
  Arg.parse [] (fun x -> loc := x) "";
  let ic = if !loc <> "" then open_in !loc else stdin in
  let parameters = 
    Parse_parameters.main Lex_parameters.token (Lexing.from_channel ic) in
  close_in ic;

  let parameters = Parse_types.convert parameters in
  let test_errors = parameters.Parse_types.test_errors 
  and test_examples = parameters.Parse_types.test_examples
  and train_examples = parameters.Parse_types.train_examples
  and train_errors = parameters.Parse_types.train_errors in
  
  if train_examples > 0 then print_string "train_error_rate = "; print_float (float train_errors /. float train_examples); print_newline();
  if test_examples > 0 then print_string "test_error_rate = "; print_float (float test_errors /. float test_examples); print_newline();
  if test_examples > 0 then begin
    let mean = float test_errors /. float test_examples in
    let sigma_squared = (mean *. mean *. float (test_examples - test_errors) 
			   +. (1. -. mean) *. (1. -. mean) *. float test_errors) /. float (test_examples - 1) in
    let sigma = sigma_squared ** 0.5 in
    let two_sigma_up, two_sigma_down = mean +. sigma *. 2., mean -. sigma *. 2. in
    print_string "broken_bound = "; print_float mean; print_char ' '; print_float two_sigma_up; print_char ' '; print_float two_sigma_down; print_newline();
  end
    
