%{

exception UNKNOWN_APPROXIMATION of string

%}
  %token <string> NAME
  %token <float> FLOAT_VAL
  %token <int> INT_VAL
  %token <bool> BOOL_VAL
  %token LOG_HYPOTHESIS_SIZE LOG_PRIOR TEST_ERRORS TRAIN_ERRORS
  %token TRAIN_EXAMPLES TEST_EXAMPLES APPROX DELTA LOWER_DELTA ERROR_LOG_COUNT 
  %token SAMPLE_SPACE_LOG_SIZE
  %token EOF
  %token EOL
  %start main
  %type <Parse_types.tags list> main

  %%
main:
  { [] }
| tag EOL main EOF { $1::$3 }
  ;

tag:
  LOG_HYPOTHESIS_SIZE float { Parse_types.Log_hypothesis_size $2 }
| LOG_PRIOR float { Parse_types.Log_prior $2 }
| SAMPLE_SPACE_LOG_SIZE float { Parse_types.Sample_space_log_size $2 }
| DELTA float { Parse_types.Delta $2 }
| LOWER_DELTA float { Parse_types.Lower_delta $2 }
| TEST_ERRORS INT_VAL { Parse_types.Test_errors $2 }
| TRAIN_ERRORS INT_VAL { Parse_types.Train_errors $2 }
| TRAIN_EXAMPLES INT_VAL { Parse_types.Train_examples $2 }
| TEST_EXAMPLES INT_VAL { Parse_types.Test_examples $2 }
| ERROR_LOG_COUNT INT_VAL float { Parse_types.Error_log_count ($2,$3) }
| APPROX NAME 
    { match $2 with 
      "hoeffding" -> Parse_types.Approximation Parse_types.Hoeffding
    | "relative_entropy" -> 
	Parse_types.Approximation Parse_types.Relative_Entropy
    | "exact" -> Parse_types.Approximation Parse_types.Exact 
    | _ -> raise (UNKNOWN_APPROXIMATION $2)}

float:
    FLOAT_VAL  { $1 }
| INT_VAL { float_of_int $1 }
    
