let agnostic_upper size num_examples num_errors p =
  let p_hat = float num_errors /. float num_examples in
  if p_hat > p then 0. 
  else
    let diff = p -. p_hat in
    min (~-. diff *. diff *. float (2 *num_examples) +. size) 0.

let agnostic_lower size num_examples num_errors p =
  let p_hat = float num_errors /. float num_examples in
  if p_hat < p then 0. 
  else
    let diff = p -. p_hat in
    min (~-. diff *. diff *. float (2 *num_examples) +. size) 0.
      
let upper_bound size num_examples num_errors log_delta =
      min 1. (float num_errors /. float num_examples
		+. sqrt ( (size -. log_delta) /. float (2 * num_examples)))

let lower_bound size num_examples num_errors log_delta =
      max 0. (float num_errors /. float num_examples
		-. sqrt ( (size -. log_delta) /. float (2 * num_examples)))
