{
open Parse_parameters
exception BADBOY of string
}
  
rule token = parse
  [' ' '\t'] { token lexbuf }
| '\n'       { EOL }
| "log_hypothesis_size"         { LOG_HYPOTHESIS_SIZE }
| "log_prior"         { LOG_PRIOR }
| "test_errors"           { TEST_ERRORS }
| "train_errors"           { TRAIN_ERRORS }
| "train_examples"           { TRAIN_EXAMPLES }
| "test_examples"           { TEST_EXAMPLES }
| "error_log_count"           { ERROR_LOG_COUNT }
| "sample_space_log_size"           { SAMPLE_SPACE_LOG_SIZE }
| "approximation"    { APPROX }
| "delta"           { DELTA }
| "lower_delta"           { LOWER_DELTA }
| "true"           { BOOL_VAL(true) }
| "false"           { BOOL_VAL(false) }
| '-'?['0'-'9']+    { INT_VAL(int_of_string(Lexing.lexeme lexbuf)) }
| '-'?['0'-'9']*'.'?['0'-'9']*('e'['+''-']['0'-'9']+)? { FLOAT_VAL(float_of_string(Lexing.lexeme lexbuf)) }
| ['a'-'z''A'-'Z''/''_''.']['a'-'z''A'-'Z''/''_''.''0'-'9']* { NAME(Lexing.lexeme lexbuf) }
| eof	 	{ EOF }
| _             { raise (BADBOY (Lexing.lexeme lexbuf)) }
    
