#include <math.h>
#include <values.h>

double log_zero = -MAXDOUBLE;
double one = 0.;

double log_add(double x, double y)
{
  if (x == log_zero) return y;
  else 
    if (y == log_zero) return x;
    else
      {
	double max_val; 
	if (x > y) 
	  max_val = x;
	else 
	  max_val = y;
	double maxed_x = x - max_val;
	double maxed_y = y - max_val;
	return log (exp(maxed_x) + exp(maxed_y)) + max_val;
      }
}

double B_i[] = {1, -1. / 2., 1. / 6., 0., - 1. / 30., 0., 1. / 42., 0., - 1. / 30., 0., 5. / 66., 0., -691. / 2730., 0., 7. / 6., 0., -3617. / 510, 0., 43867. / 798., 0., - 174611. / 330., 0., 854513./138.};
int B_length = 16;

double half_log_two_pi = 0.5 * log (2. * 3.14159);

//Calculate n!  
//Approximation = Stirling's series
double approx_log_factorial(int n)
{
  if (n == 0)
    return 0.;
  else
    {
      double z = (double) (n + 1);
      double ret = half_log_two_pi + (z - 0.5) * log(z) - z;
      for (int i = 1; i <= B_length / 2; i++)
	ret += B_i[i*2] / ((double) 2*i * (2*i - 1)) / pow(z, (double) 2*i - 1);
      return ret;
    }
}

//Calculate n choose i
double approx_log_choose(int n, int i)
{
  return approx_log_factorial(n) - approx_log_factorial(i) - approx_log_factorial(n-i);
}

